'*************************************************************
' 
' ADOBE SYSTEMS INCORPORATED 
' Copyright 2005-2010 Adobe Systems Incorporated 
' All Rights Reserved 

' NOTICE:  Adobe permits you to use, modify, and 
' distribute this file in accordance with the terms
' of the Adobe license agreement accompanying it.  
' If you have received this file from a source 
' other than Adobe, then your use, modification,
' or distribution of it requires the prior 
' written permission of Adobe. 
' 
'*************************************************************

' WebGallery.vbs

' DESCRIPTION

' This example demonstrates how a gallery can be created from 
' several Illustrator compatible files.
' The script first creates .ai and .pdf files then saves them 
' in a 'WebGallery' folder on the desktop, Illustrator 
' will then scan the WebGallery folder for files 
' and load them into Illustrator. Once in Illustrator the 
' documents are exported to JPEG and HTML format and an HTML file 
' is created which displays the files in a gallery format.
'
'*************************************************************
    Dim objApp
    Dim objExportOptions
    Dim objFileSys
    Dim objFile
    Dim objFiles
    Dim objFolder
    Dim objFolderGall
    Dim objFolderImg
    Dim objFolderPage
    Dim objFolderThumb
    Dim theFiles
    Dim f1 
    Dim myName
    Dim myPath
    Dim htmlFrame
    Dim htmlPage
    Dim htmlIndex
    Dim htmlIndexRow
    Dim htmlIndexRows
    Dim success
    Dim objFolderSamp
    Dim newItem
    Dim itemColor
    Dim pdfSvOpts
    Dim textRef
    
    const DESKTOP = &H0&
	set myShell = CreateObject("Shell.Application")
	set myDesktopFolder = myShell.Namespace(DESKTOP)
	set myDesktopFolderItem = myDesktopFolder.Self
	myDesktopPath = myDesktopFolderItem.Path
    
    Set objApp = CreateObject("Illustrator.Application")
    Set objExportOptions = CreateObject("Illustrator.ExportOptionsJPEG")
    Set objFileSys = CreateObject("Scripting.FileSystemObject")
    Set objFolder = objFileSys.GetFolder(myDesktopPath)
    Set pdfSvOpts = CreateObject("Illustrator.PDFSaveOptions")
    Set aiSvOpts = CreateObject("Illustrator.IllustratorSaveOptions")
    myMsg = "alert(""Creates 3 documents, saves the documents to a folder " & _
    "called \'WebGallery\' on the Desktop, exports each document as jpeg " & _
    "and html then creates the html gallery file - index.html."")"
    objApp.DoJavaScript myMsg
    
    ' check for folders and create if they don't exist
    If (objFileSys.FolderExists(objFolder & "\WebGallery")) Then
        Set objFolderSamp = objFileSys.GetFolder(objFolder & "\WebGallery")
	Else
        Set objFolderSamp = objFolder.SubFolders.Add("WebGallery")
    End If
    
	If (objFileSys.FolderExists(objFolderSamp & "\gallery")) Then
		Set objFolderGall = objFileSys.GetFolder(objFolderSamp & "\gallery")
	Else
		Set objFolderGall = objFolderSamp.SubFolders.Add("gallery")
	End If
	
	If (objFileSys.FolderExists(objFolderGall & "\images")) Then
		Set objFolderImg = objFileSys.GetFolder(objFolderGall & "\images")
	Else
		Set objFolderImg = objFolderGall.SubFolders.Add("images")
	End If

	If (objFileSys.FolderExists(objFolderGall & "\pages")) Then
		Set objFolderPage = objFileSys.GetFolder(objFolderGall & "\pages")
	Else
		Set objFolderPage = objFolderGall.SubFolders.Add("pages")
	End If
	
	If (objFileSys.FolderExists(objFolderGall & "\thumbnails")) Then
		Set objFolderThumb = objFileSys.GetFolder(objFolderGall & "\thumbnails")
	Else
		Set objFolderThumb = objFolderGall.SubFolders.Add("thumbnails")
	End If    
    
    'reserved characters (can't be in filenames processed)
    ' ^ (repeating index rows)
    ' ~ (image number)
    
    'create and save a document with a star in it
    Set docRef = objApp.Documents.Add
    Set newItem = docRef.PathItems.Star(300,400,100,50,5)
    Set itemColor = CreateObject("Illustrator.CMYKColor")
    itemColor.Magenta = 100
    newItem.FillColor = itemColor
    docRef.SaveAs (objFolderSamp & "\star.ai")

    'create and save a document with an ellipse in it
    Set docRef = objApp.Documents.Add
    Set newItem = docRef.PathItems.Ellipse(200,200,200,100)
    Set itemColor = CreateObject("Illustrator.CMYKColor")
    itemColor.Yellow = 100
    newItem.FillColor = itemColor
    docRef.SaveAs (objFolderSamp & "\ellipse.ai")

    'create and save a pdf file with some text
    Set docRef = objApp.Documents.Add
    Set textRef = docRef.TextFrames.Add()
    textRef.Contents = "Here is text from the PDF file."
    textRef.Top = 400
    textRef.Left = 100
    textRef.TextRange.CharacterAttributes.Size = 18
    objApp.Redraw
    pdfSvOpts.AcrobatLayers = true
    docRef.SaveAs objFolderSamp & "\text.pdf",pdfSvOpts

    'standard frameset html
    htmlFrame = ""
    htmlFrame = htmlFrame & "<HTML>" & vbCrLf
    htmlFrame = htmlFrame & "<HEAD>" & vbCrLf
    htmlFrame = htmlFrame & "<TITLE>Web Gallery</TITLE>" & vbCrLf
    htmlFrame = htmlFrame & "<META name=""generator"" content=""Adobe Illustrator Script-Generated Web Gallery"">" & vbCrLf
    htmlFrame = htmlFrame & "<META http-equiv=""Content-Type"" content=""text/html; charset=iso-8859-1"">" & vbCrLf
    htmlFrame = htmlFrame & "</HEAD>" & vbCrLf
    htmlFrame = htmlFrame & "<FRAMESET frameborder=1 cols=""20%,80%"">" & vbCrLf
    htmlFrame = htmlFrame & "<FRAME src=""index.html""  NAME=""LeftFrame""  scrolling=YES>" & vbCrLf
    htmlFrame = htmlFrame & "<FRAME src=""pages/1.html""  name=""RightFrame"" scrolling=YES>" & vbCrLf
    htmlFrame = htmlFrame & "<NOFRAMES>" & vbCrLf
    htmlFrame = htmlFrame & "<BODY>" & vbCrLf
    htmlFrame = htmlFrame & "Viewing this page requires a browser capable of displaying frames." & vbCrLf
    htmlFrame = htmlFrame & "</BODY>" & vbCrLf
    htmlFrame = htmlFrame & "</NOFRAMES>" & vbCrLf
    htmlFrame = htmlFrame & "</FRAMESET>" & vbCrLf
    htmlFrame = htmlFrame & "</HTML>" & vbCrLf
    'write frameset
    Set objFile = objFileSys.CreateTextFile(objFolderGall.Path & "\" & "frameset.html", True, False)
    objFile.Write htmlFrame
    objFile.Close
    
    'standard thumb index html
    htmlIndex = ""
    htmlIndex = htmlIndex & "<HTML>" & vbCrLf
    htmlIndex = htmlIndex & "<HEAD>" & vbCrLf
    htmlIndex = htmlIndex & "<TITLE>Web Gallery</TITLE>" & vbCrLf
    htmlIndex = htmlIndex & "<META name=""generator"" content=""Adobe Illustrator Script-Generated Web Gallery"">" & vbCrLf
    htmlIndex = htmlIndex & "<META http-equiv=""Content-Type"" content=""text/html; charset=iso-8859-1"">" & vbCrLf
    htmlIndex = htmlIndex & "</HEAD>" & vbCrLf
    htmlIndex = htmlIndex & "<BODY bgcolor=""#FFFFFF""  text=""#000000""  link=""#FF0000""  vlink=""#CCCC99""  alink=""#0000FF"" >" & vbCrLf
    htmlIndex = htmlIndex & "Thumbnails with hyperlinks" & vbCrLf
    htmlIndex = htmlIndex & "<P><TABLE border=""0"" cellspacing=""2"" cellpadding=""0"">" & vbCrLf
    htmlIndex = htmlIndex & "^" & vbCrLf
    'repeating row
    htmlIndexRow = ""
    htmlIndexRow = htmlIndexRow & "<TR><TD>" & vbCrLf
    htmlIndexRow = htmlIndexRow & "<P><A href=""pages/~.html"" target=""RightFrame""><IMG src=""thumbnails/~.jpg"" border=""0"" alt=1 align=""BOTTOM""></A><BR><BR>" & vbCrLf
    htmlIndexRow = htmlIndexRow & "<A href=""pages/~.html"" target=""RightFrame""><FONT size=""2""  face=""Arial"" >~.jpg</FONT></A><FONT size=""2""  face=""Arial"" ></FONT><BR><BR>" & vbCrLf
    htmlIndexRow = htmlIndexRow & "</TD></TR>" & vbCrLf
    '
    htmlIndex = htmlIndex & "</TABLE>" & vbCrLf
    htmlIndex = htmlIndex & "</BODY>" & vbCrLf
    htmlIndex = htmlIndex & "</HTML>" & vbCrLf
    'clear running string for final insertion
    htmlIndexRows = ""
    
    'standard image page html
    htmlPage = ""
    htmlPage = htmlPage & "</HTML>" & vbCrLf
    htmlPage = htmlPage & "<HTML>" & vbCrLf
    htmlPage = htmlPage & "<HEAD>" & vbCrLf
    htmlPage = htmlPage & "<TITLE>~</TITLE>" & vbCrLf
    htmlPage = htmlPage & "<META name=""generator"" content=""Adobe Illustrator Script-Generated Web Gallery"">" & vbCrLf
    htmlPage = htmlPage & "<META http-equiv=""Content-Type"" content=""text/html; charset=iso-8859-1"">" & vbCrLf
    htmlPage = htmlPage & "</HEAD>" & vbCrLf
    htmlPage = htmlPage & "<BODY bgcolor=""#FFFFFF""  text=""#000000""  link=""#FF0000""  vlink=""#CCCC99""  alink=""#0000FF"" >" & vbCrLf
    htmlPage = htmlPage & "<TABLE border=""0"" cellpadding=""5"" cellspacing=""2"" width=""100%"" bgcolor=""#F0F0F0"" >" & vbCrLf
    htmlPage = htmlPage & "<TR>" & vbCrLf
    htmlPage = htmlPage & "<TD><FONT size=""2"" face=""Arial"" >Web Gallery / ~<BR><BR>" & Date & "</FONT>" & vbCrLf
    htmlPage = htmlPage & "</TD>" & vbCrLf
    htmlPage = htmlPage & "</TR>" & vbCrLf
    htmlPage = htmlPage & "</TABLE>" & vbCrLf
    htmlPage = htmlPage & "<P><CENTER><IMG src=""../images/~.jpg""  border=""0"" alt=1></CENTER></P>" & vbCrLf
    htmlPage = htmlPage & "</BODY>" & vbCrLf
    
    'loop thru all files that Illustrator can open
        Set theFiles = objFolderSamp.Files
        Dim i
        i = 0
        For Each f1 In theFiles
        i = i + 1
            myPath = f1.Path
            'open document in illustrator
            objApp.Open (myPath)
            
            If objApp.Documents.Count > 0 Then
                objExportOptions.HorizontalScale = 20
                objExportOptions.VerticalScale = 20
                objApp.Documents(1).Export objFolderThumb.Path & "\" & i & ".jpg", 1, objExportOptions
                objExportOptions.HorizontalScale = 75
                objExportOptions.VerticalScale = 75
                objApp.Documents(1).Export objFolderImg.Path & "\" & i & ".jpg", 1, objExportOptions
                objApp.Documents(1).Close (2) 'aiDoNotSaveChanges
                htmlIndexRows = htmlIndexRows & Replace(htmlIndexRow, "~", i)
                'and creating a page html file
                Set objFile = objFileSys.CreateTextFile(objFolderPage.Path & "\" & i & ".html", True, False)
                objFile.Write Replace(htmlPage, "~", i)
                objFile.Close
            End If
        Next
    
        'save thumbnail index
        htmlIndex = Replace(htmlIndex, "^", htmlIndexRows)
        Set objFile = objFileSys.CreateTextFile(objFolderGall.Path & "\" & "index.html", True, False)
        objFile.Write Replace(htmlIndex, "~", i)
        objFile.Close
'' SIG '' Begin signature block
'' SIG '' MIIY1QYJKoZIhvcNAQcCoIIYxjCCGMICAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFNlCYHyaBjXj
'' SIG '' QaKgulyfTpGtF18loIITuzCCA+4wggNXoAMCAQICEH6T
'' SIG '' 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
'' SIG '' CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
'' SIG '' cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
'' SIG '' EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
'' SIG '' Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
'' SIG '' aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
'' SIG '' NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
'' SIG '' bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
'' SIG '' bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
'' SIG '' RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
'' SIG '' AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
'' SIG '' FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
'' SIG '' a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
'' SIG '' AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
'' SIG '' +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
'' SIG '' 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
'' SIG '' 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
'' SIG '' RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
'' SIG '' gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
'' SIG '' gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
'' SIG '' aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
'' SIG '' CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
'' SIG '' Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
'' SIG '' bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
'' SIG '' VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
'' SIG '' VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
'' SIG '' BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
'' SIG '' nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
'' SIG '' sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
'' SIG '' JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
'' SIG '' g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
'' SIG '' UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
'' SIG '' MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
'' SIG '' BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
'' SIG '' dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
'' SIG '' MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
'' SIG '' VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
'' SIG '' AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
'' SIG '' cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
'' SIG '' ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
'' SIG '' sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
'' SIG '' duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
'' SIG '' TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
'' SIG '' YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
'' SIG '' vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
'' SIG '' nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
'' SIG '' 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
'' SIG '' EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
'' SIG '' FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
'' SIG '' BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
'' SIG '' AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
'' SIG '' MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
'' SIG '' bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
'' SIG '' MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
'' SIG '' ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
'' SIG '' MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
'' SIG '' VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
'' SIG '' IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
'' SIG '' SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
'' SIG '' st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
'' SIG '' JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
'' SIG '' dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
'' SIG '' bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
'' SIG '' K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
'' SIG '' SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
'' SIG '' ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
'' SIG '' w7wc2AR1MIIFVjCCBD6gAwIBAgIQGRoyy3Wcl7jPrBGN
'' SIG '' 1RJ/STANBgkqhkiG9w0BAQsFADCByjELMAkGA1UEBhMC
'' SIG '' VVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYD
'' SIG '' VQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYD
'' SIG '' VQQLEzEoYykgMjAwNiBWZXJpU2lnbiwgSW5jLiAtIEZv
'' SIG '' ciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxW
'' SIG '' ZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENl
'' SIG '' cnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzUwHhcNMTQw
'' SIG '' MzA0MDAwMDAwWhcNMjQwMzAzMjM1OTU5WjCBkTELMAkG
'' SIG '' A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
'' SIG '' cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
'' SIG '' ZXR3b3JrMUIwQAYDVQQDEzlTeW1hbnRlYyBDbGFzcyAz
'' SIG '' IEV4dGVuZGVkIFZhbGlkYXRpb24gQ29kZSBTaWduaW5n
'' SIG '' IENBIC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
'' SIG '' ggEKAoIBAQDQGALu7aKNCFhjDybX3SJ7iPbkx+w7Jhh4
'' SIG '' 08ekIFONg3ylP36lyCtH3w31ptnDHSWTYM983OoDLL54
'' SIG '' f1xIbacC2Un4oevrmmF8n8Am1twV2LgQfCC6XvQo9qjq
'' SIG '' p1x8xpyQkDQ8tiKs/roMOh7WXoS2W/CjgXB4io1GUnv8
'' SIG '' 20nzKRMRdE+NFrPC46AtxwMEnczDcuEODPsCjvEmF3tu
'' SIG '' rvi3M4umYUtF3/IlRMf3sJgjNtwoeQrom3KIqNjornt/
'' SIG '' CmRFpfBXkpp3BkUe65/oZvN6fZKBXwAtHrj2VhNaYg23
'' SIG '' R6GPcu+DXoLglJjhrKWthjfgp9O6sT5660Wo8cFEfeID
'' SIG '' AgMBAAGjggFtMIIBaTASBgNVHRMBAf8ECDAGAQH/AgEA
'' SIG '' MC8GA1UdHwQoMCYwJKAioCCGHmh0dHA6Ly9zLnN5bWNi
'' SIG '' LmNvbS9wY2EzLWc1LmNybDAWBgNVHSUBAf8EDDAKBggr
'' SIG '' BgEFBQcDAzAOBgNVHQ8BAf8EBAMCAQYwLgYIKwYBBQUH
'' SIG '' AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
'' SIG '' ZC5jb20wXwYDVR0gBFgwVjBUBgRVHSAAMEwwIwYIKwYB
'' SIG '' BQUHAgEWF2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUG
'' SIG '' CCsGAQUFBwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20v
'' SIG '' cnBhMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFTeW1h
'' SIG '' bnRlY1BLSS0xLTYyOTAdBgNVHQ4EFgQUFmbeSjTjUKcR
'' SIG '' hgOxbKnGrM1ZbpswHwYDVR0jBBgwFoAUf9Nlp8Ld7Lvw
'' SIG '' MAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQELBQADggEBAD9b
'' SIG '' GfP6E9V1OCpa7p9aoEypHcXMlO7eFf71EG6kG6Vkg1QY
'' SIG '' WMQLKKGFw0505f+JfP7V7Ty6cZ9WAiaPFiqI/rCjJyLO
'' SIG '' S+I4jgCmOoZfneU+qN5kSUF0QSH9B8iEF9odZTCCyyZP
'' SIG '' OdYEJ6SBsUtJwyOLfgIyGCe3qwvzGHK2pO5nBm84pliN
'' SIG '' 4PF+XaRgxqjlUF/g6Lrij5lYtrWgqHbxovEciEFyflKX
'' SIG '' mwo2mY1Q9wHrPOfwImrlNYxjNooasdlnZl+XGu+oIJ3w
'' SIG '' L7psztmUhQDxWPF9yXwitQddAsbmC7+rk5P/JxiOMzZ+
'' SIG '' VzTxw68EwYTxVrPoh4M2+NMKMdxuLG0wggXEMIIErKAD
'' SIG '' AgECAhAeObM6nEaakCI61S77g784MA0GCSqGSIb3DQEB
'' SIG '' CwUAMIGRMQswCQYDVQQGEwJVUzEdMBsGA1UEChMUU3lt
'' SIG '' YW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsTFlN5bWFu
'' SIG '' dGVjIFRydXN0IE5ldHdvcmsxQjBABgNVBAMTOVN5bWFu
'' SIG '' dGVjIENsYXNzIDMgRXh0ZW5kZWQgVmFsaWRhdGlvbiBD
'' SIG '' b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNTExMDYwMDAw
'' SIG '' MDBaFw0xNzEwMjgyMzU5NTlaMIIBDjETMBEGCysGAQQB
'' SIG '' gjc8AgEDEwJVUzEZMBcGCysGAQQBgjc8AgECFAhEZWxh
'' SIG '' d2FyZTEdMBsGA1UEDxMUUHJpdmF0ZSBPcmdhbml6YXRp
'' SIG '' b24xEDAOBgNVBAUTBzI3NDgxMjkxCzAJBgNVBAYTAlVT
'' SIG '' MRMwEQYDVQQIDApDYWxpZm9ybmlhMREwDwYDVQQHDAhT
'' SIG '' YW4gSm9zZTEjMCEGA1UECgwaQWRvYmUgU3lzdGVtcyBJ
'' SIG '' bmNvcnBvcmF0ZWQxLDAqBgNVBAsMI0lsbHVzdHJhdG9y
'' SIG '' LCBJbkRlc2lnbiwgSW5Db3B5LCBNdXNlMSMwIQYDVQQD
'' SIG '' FBpBZG9iZSBTeXN0ZW1zIEluY29ycG9yYXRlZDCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJpOMyAj
'' SIG '' 8r+7FuNs3MXed0OMajoJnoF4v8cV+9drUVII+pzb6yeV
'' SIG '' GdBTt8U03rk1a2V51gcTHAorQxs2plJIgafn/pqMzG7f
'' SIG '' 9FZui7WiMOuyif/0joytDGujeQd7xQ/23YYtZpQQ/ahz
'' SIG '' VI4Pzv44FVDGwHYfGxGaQ127Bqp5EhLX7zwFiGEPnP3V
'' SIG '' R4ZyQn2WQeA0a68KuhD6anNHize0XjSBFelrNhN4uYpk
'' SIG '' prXyGv8vKdq9a911iY/efPsRueUPYucYJCF/lBt3DaR4
'' SIG '' J/FeaSJeijyllNwAqu7XY7Jl9zB0duRLlRFpGJeCymhY
'' SIG '' 3wvU6039CHBnrYIXZ/ldAWUpz+MCAwEAAaOCAZYwggGS
'' SIG '' MC4GA1UdEQQnMCWgIwYIKwYBBQUHCAOgFzAVDBNVUy1E
'' SIG '' RUxBV0FSRS0yNzQ4MTI5MAkGA1UdEwQCMAAwKwYDVR0f
'' SIG '' BCQwIjAgoB6gHIYaaHR0cDovL3N3LnN5bWNiLmNvbS9z
'' SIG '' dy5jcmwwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwMwDgYD
'' SIG '' VR0PAQH/BAQDAgeAMGYGA1UdIARfMF0wWwYLYIZIAYb4
'' SIG '' RQEHFwYwTDAjBggrBgEFBQcCARYXaHR0cHM6Ly9kLnN5
'' SIG '' bWNiLmNvbS9jcHMwJQYIKwYBBQUHAgIwGQwXaHR0cHM6
'' SIG '' Ly9kLnN5bWNiLmNvbS9ycGEwHQYDVR0OBBYEFPsxU7iZ
'' SIG '' MQ82sRMZZ9wcUZpCtgBaMFgGCCsGAQUFBwEBBEwwSjAf
'' SIG '' BggrBgEFBQcwAYYTaHR0cDovL3N3LnN5bWNkLmNvbTAn
'' SIG '' BggrBgEFBQcwAoYbaHR0cDovL3N3MS5zeW1jYi5jb20v
'' SIG '' c3cuY3J0MB8GA1UdIwQYMBaAFBZm3ko041CnEYYDsWyp
'' SIG '' xqzNWW6bMA0GCSqGSIb3DQEBCwUAA4IBAQBQEAjwXAas
'' SIG '' FygBRU/4fmAgJdTZDZFT/Gri5Vi28b6iHzDnTKcr3QTJ
'' SIG '' 33Ql9LbIi2CjtnD1n0zyvIdjXDXFLcbeMoQQ9L5XuiRw
'' SIG '' kwUPpRrLYsNPQ8G3n7N/me223Sw4noAy0ErrUNZd4Bew
'' SIG '' mTc3hn/95O1LC9QuGNFv/l+RyyFXBe3iJvHOpMBwIkMa
'' SIG '' OXB5/2FbFLqqELV4zWE2GXHhxfgxTgHHww1pJNBdPpxR
'' SIG '' qIjQxmgkL24azZZyxxtRWI6mpgCu+/4ZeXzwKSMycBYc
'' SIG '' gVG9c5TUSh+s1a4HPrrBJ1lPJQ+8+v3rc6ytjZXAC/g8
'' SIG '' GhhIrxvatjLMNWzrFNG7iEciMYIEhjCCBIICAQEwgaYw
'' SIG '' gZExCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
'' SIG '' YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMg
'' SIG '' VHJ1c3QgTmV0d29yazFCMEAGA1UEAxM5U3ltYW50ZWMg
'' SIG '' Q2xhc3MgMyBFeHRlbmRlZCBWYWxpZGF0aW9uIENvZGUg
'' SIG '' U2lnbmluZyBDQSAtIEcyAhAeObM6nEaakCI61S77g784
'' SIG '' MAkGBSsOAwIaBQCggaYwGQYJKoZIhvcNAQkDMQwGCisG
'' SIG '' AQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisGAQQB
'' SIG '' gjcCARUwIwYJKoZIhvcNAQkEMRYEFMLMOi/PEORQ/9aH
'' SIG '' K2JZhnCz74ZwMEYGCisGAQQBgjcCAQwxODA2oDSAMgBB
'' SIG '' AGQAbwBiAGUAIABJAGwAbAB1AHMAdAByAGEAdABvAHIA
'' SIG '' IABDAEMAIAAyADAAMQA1MA0GCSqGSIb3DQEBAQUABIIB
'' SIG '' AA3+tYOSi4bxUDdIuvcxRCjtVIzPs6Iy9KwTgUIwvtr6
'' SIG '' iiQTKsYpqnIajCrsrmc1O3tpoOh5h3UE7w6GPeyGVXcg
'' SIG '' 8qDhEMFKFmMXo+YuhhW4OKudK6RUpbRx3hW0e1nnM03o
'' SIG '' sE0rzBw+eIZy6JgITRQ4P3rWeoy0AkGC/U7lVRp9bHAf
'' SIG '' SH3U5G6/2T8CUJLfpcBf8S1GqQJ0B3HaX+M7T5wAa0cE
'' SIG '' 5D+qjjPPHrnT+4KHzH9RGa5BEn/L7gucGe7mpN+nH62p
'' SIG '' HtKl4ba63PQbKa8SlbWWYoBueXv68mmJC3niSNPsY8cq
'' SIG '' cG9tN+gx+7IMj6FPRdCHAa4eftPHZGwLSXihggILMIIC
'' SIG '' BwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBeMQswCQYD
'' SIG '' VQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9y
'' SIG '' YXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUgU3Rh
'' SIG '' bXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQDs/0OMj+vzVu
'' SIG '' BNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkD
'' SIG '' MQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcNMTYw
'' SIG '' MTE0MjMxOTAwWjAjBgkqhkiG9w0BCQQxFgQUbj7d8oYN
'' SIG '' jHDWFoiVa9ZpcA/4dn4wDQYJKoZIhvcNAQEBBQAEggEA
'' SIG '' h/u6y+8j9kvNbWjiz0cDFJW2qDyfyKL/agmk7AzLN7YQ
'' SIG '' 1sc/O2B8cJ0n0FlYUnu/Etm+CrWhgWToKmw5CRnseOey
'' SIG '' 9/D0Ymryx6auj9gpIx6OoT8AFjA5s7csipBPsUEVJEDl
'' SIG '' v99T7Sd7lRNPpx5MhaUtd+ZeLZvCNciW8se9atua+3DF
'' SIG '' RuNTgRK9HCV6AtFyyOAcH6fBQNIkN79Tg68uOfQfaz5u
'' SIG '' bNa1XyoKFQM2wd4zpH5BW5ebciXyq7ix0tws3hQCZfRW
'' SIG '' b8/JAD90FOqDwzC9TDN/8WXq5Aji3cAKCuYZcCqiyulr
'' SIG '' oqg6RegCJgZb9UWSFEC3A5KVL57FJ+AUCw==
'' SIG '' End signature block
